/* Approve Invoice must be DISABLED for all users by Default.
   If the setting has already been disabled for at least one user,
   we'll assume that this has now been set up correctly.
   Otherwise we will set it up at this point */
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[KHCtlGroups] [KHC]
          INNER JOIN [dbo].[KHCtlHandlers] [KHH]
                  ON [KHH].[groupid] = [KHC].[id]
                 AND [KHH].[AllHandlers] = 0
    WHERE [KHC].[GroupName] = 'Approve Invoice')
  BEGIN
    INSERT
      INTO [dbo].[KHCtlHandlers]
          ([Handler],
           [groupid],
           [AllHandlers])
    SELECT [HAN].[CODE],
           [KHC].[id],
           0
      FROM [dbo].[Handlers] [HAN]
           INNER JOIN [dbo].[KHCtlGroups] [KHC]
                   ON [KHC].[GroupName] = 'Approve Invoice'
  END
GO

/* Release High Value Cheques must be DISABLED for all users by Default.
   If the setting has already been disabled for at least one user,
   we'll assume that this has now been set up correctly.
   Otherwise we will set it up at this point */
IF NOT EXISTS
  (SELECT TOP 1 1
     FROM [dbo].[KHCtlGroups] [KHC]
          INNER JOIN [dbo].[KHCtlHandlers] [KHH]
                  ON [KHH].[groupid] = [KHC].[id]
                 AND [KHH].[AllHandlers] = 0
    WHERE [KHC].[GroupName] = 'Release High Value Cheques')
  BEGIN
    INSERT
      INTO [dbo].[KHCtlHandlers]
          ([Handler],
           [groupid],
           [AllHandlers])
    SELECT [HAN].[CODE],
           [KHC].[id],
           0
      FROM [dbo].[Handlers] [HAN]
           INNER JOIN [dbo].[KHCtlGroups] [KHC]
                   ON [KHC].[GroupName] = 'Release High Value Cheques'
  END
GO
